﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;

namespace OcadMapLibrary {

	public class RectangleObject : MapObject {

		Rect data;
		public Rect Data {
			get {
				return data;
			}
			set {
				data = value;
			}
		}

		public override void DrawObject(DrawingContext drawingContext, List<MapSymbol> mapSymbols, MapColor mapColor) {
			RectangleSymbol symbol = (RectangleSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return;
			}
			if (symbol.IsHidden) {
				return;
			}
			if (data.IsEmpty) {
				return;
			}
			if (!symbol.StrokeColor.Matches(mapColor)) {
				return;
			}
			if (symbol.StrokeThickness<=0) {
				return;
			}
			Brush brush = new SolidColorBrush(mapColor.Color);
			Pen pen = new Pen(brush, symbol.StrokeThickness);
			drawingContext.DrawRoundedRectangle(null, pen, data, symbol.CornerRadiusX, symbol.CornerRadiusY);
		}

		public override Rect GetBoundingRect(List<MapSymbol> mapSymbols) {
			RectangleSymbol symbol = (RectangleSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			Rect rect = Rect.Empty;
			if (symbol == null) {
				return rect;
			}
			if (symbol.IsHidden) {
				return rect;
			}
			rect = data;
			rect.Inflate(symbol.StrokeThickness / 2, symbol.StrokeThickness / 2);
			return rect;
		}

	}

}
