﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace OcadMapLibrary {

	public class PointSymbolArea : PointSymbolElement {

		MapAreaGeometry data;
		public MapAreaGeometry Data {
			get {
				return data;
			}
			set {
				data = value;
			}
		}

		MapColorRef fillColor;
		public MapColorRef FillColor {
			get {
				return fillColor;
			}
			set {
				fillColor = value;
			}
		}

		public override void Draw(DrawingContext drawingContext, MapColor mapColor) {
			if (FillColor == null) {
				return;
			}
			if (!FillColor.Matches(mapColor)) {
				return;
			}
			PathGeometry geometry = data.GetGeometry();
			drawingContext.DrawGeometry(new SolidColorBrush(mapColor.Color), null, geometry);
		}

		public override Rect GetBoundingRect(Point position) {
			Rect rect = Rect.Empty;
			if (FillColor == null) {
				return rect;
			}
			PathGeometry geometry = data.GetGeometry();
			rect = geometry.Bounds;
			if (!rect.IsEmpty) {
				rect.Offset(position.X, position.Y);
			}
			return rect;
		}

		public override bool ContainsColor(MapColor mapColor) {
			if (FillColor != null) {
				if (FillColor.Matches(mapColor)) {
					return true;
				}
			}
			return false;
		}

	}

}
