﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace OPlanner {
	
	public partial class MapSettings : Window {

		public MapSettings() {
			InitializeComponent();
		}

		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
			Update();
		}

		private void Update() {
			Clear();
			scaleBox.Text = info.Data.MapScale.ToString();
			scaleMapByBox.Text = info.Data.ScaleMapBy.ToString();
			controlSizeBox.Text = OPlannerHelper.PixelsToMillimetres(info.Data.ControlSize).ToString();
			lineWidthBox.Text = OPlannerHelper.PixelsToMillimetres(info.Data.LineWidth).ToString();
			controlColourBox.Text = info.Data.ControlColour;
			numberOffsetBox.Text = OPlannerHelper.PixelsToMillimetres(info.Data.NumberOffsetDistance).ToString();
			numberSizeBox.Text = OPlannerHelper.PixelsToMillimetres(info.Data.NumberSize).ToString();
			descriptionSizeBox.Text = OPlannerHelper.PixelsToMillimetres(info.Data.DescriptionSize).ToString();
		}

		private void Clear() {
			scaleBox.Text = "";
			scaleMapByBox.Text = "";
			controlSizeBox.Text = "";
			lineWidthBox.Text = "";
			controlColourBox.Text = "";
			numberOffsetBox.Text = "";
			numberSizeBox.Text = "";
			descriptionSizeBox.Text = "";
		}

		private bool Validate(bool showErrors) {
			ErrorManager errorManager = new ErrorManager();
			double num;
			if (scaleBox.Text == "") {
				errorManager.AddError("Scale is required");
			} else {
				if (!double.TryParse(scaleBox.Text, out num)) {
					errorManager.AddError("Scale must be a number");
				} else {
					if (num <= 0) {
						errorManager.AddError("Scale must be a positive number");
					}
				}
			}
			if (scaleMapByBox.Text == "") {
				errorManager.AddError("Scale map by is required");
			} else {
				if (!double.TryParse(scaleMapByBox.Text, out num)) {
					errorManager.AddError("Scale map by must be a number");
				} else {
					if (num <= 0) {
						errorManager.AddError("Scale map by must be a positive number");
					}
				}
			}
			if (controlSizeBox.Text == "") {
				errorManager.AddError("Control size is required");
			} else {
				if (!double.TryParse(controlSizeBox.Text, out num)) {
					errorManager.AddError("Control size must be a number");
				} else {
					if (num <= 0) {
						errorManager.AddError("Control size must be a positive number");
					}
				}
			}
			if (lineWidthBox.Text == "") {
				errorManager.AddError("Line width is required");
			} else {
				if (!double.TryParse(lineWidthBox.Text, out num)) {
					errorManager.AddError("Line width must be a number");
				} else {
					if (num <= 0) {
						errorManager.AddError("Line width must be a positive number");
					}
				}
			}
			if (numberSizeBox.Text == "") {
				errorManager.AddError("Number size is required");
			} else {
				if (!double.TryParse(numberSizeBox.Text, out num)) {
					errorManager.AddError("Number size must be a number");
				} else {
					if (num <= 0) {
						errorManager.AddError("Number size must be a positive number");
					}
				}
			}
			if (numberOffsetBox.Text == "") {
				errorManager.AddError("Number offset is required");
			} else {
				if (!double.TryParse(numberOffsetBox.Text, out num)) {
					errorManager.AddError("Number offset must be a number");
				} else {
					if (num < 0) {
						errorManager.AddError("Number offset must be a positive number");
					}
				}
			}
			if (controlColourBox.Text == "") {
				errorManager.AddError("Control colour is required");
			} else {
				try {
					ColorConverter.ConvertFromString(controlColourBox.Text);
				} catch (Exception) {
					errorManager.AddError("Control colour is invalid");
				}
			}
			if (descriptionSizeBox.Text == "") {
				errorManager.AddError("Description size is required");
			} else {
				if (!double.TryParse(descriptionSizeBox.Text, out num)) {
					errorManager.AddError("Description size must be a number");
				} else {
					if (num <= 0) {
						errorManager.AddError("Description size must be a positive number");
					}
				}
			}
			if (showErrors) {
				errorManager.ShowErrors(this);
			}
			return !errorManager.HasErrors;
		}

		private void saveButton_Click(object sender, RoutedEventArgs e) {
			if (!Validate(true)) {
				return;
			}
			double controlSize = double.Parse(controlSizeBox.Text);
			double lineWidth = double.Parse(lineWidthBox.Text);
			double numberSize = double.Parse(numberSizeBox.Text);
			double scale = double.Parse(scaleBox.Text);
			double scaleMapBy = double.Parse(scaleMapByBox.Text);
			double numberOffsetDistance = double.Parse(numberOffsetBox.Text);
			double descriptionSize = double.Parse(descriptionSizeBox.Text);
			bool changed = false;
			if (controlColourBox.Text != info.Data.ControlColour || controlSize != info.Data.ControlSize || lineWidth != info.Data.LineWidth || numberSize != info.Data.NumberSize || scale != info.Data.MapScale || numberOffsetDistance != info.Data.NumberOffsetDistance || descriptionSize != info.Data.DescriptionSize || scaleMapBy != info.Data.ScaleMapBy) {
				changed = true;
			}
			if (changed) {
				info.InvokeDataChanging(this, "Update Settings");
				info.Data.ControlSize = OPlannerHelper.MillimetresToPixels(controlSize);
				info.Data.LineWidth = OPlannerHelper.MillimetresToPixels(lineWidth);
				info.Data.ControlColour = controlColourBox.Text;
				info.Data.NumberSize = OPlannerHelper.MillimetresToPixels(numberSize);
				info.Data.NumberOffsetDistance = OPlannerHelper.MillimetresToPixels(numberOffsetDistance);
				info.Data.MapScale = scale;
				info.Data.ScaleMapBy = scaleMapBy;
				info.Data.DescriptionSize = OPlannerHelper.MillimetresToPixels(descriptionSize);
				info.InvokeDataChanged(this, "Update Settings");
				info.InvokeObjectsUpdated(this, UpdateType.Redraw, null, true);
				info.InvokeMapUpdated(this);
			}
			Close();
		}

		private void cancelButton_Click(object sender, RoutedEventArgs e) {
			Close();
		}

		private void resetScaleButton_Click(object sender, RoutedEventArgs e) {
			scaleBox.Text = OPlannerDefaults.MapScale.ToString();
		}

		private void resetScaleMapByButton_Click(object sender, RoutedEventArgs e) {
			scaleMapByBox.Text = "100";
		}

		private void resetControlSizeButton_Click(object sender, RoutedEventArgs e) {
			controlSizeBox.Text = OPlannerHelper.PixelsToMillimetres(OPlannerDefaults.ControlSize).ToString();
		}

		private void resetLineWidthButton_Click(object sender, RoutedEventArgs e) {
			lineWidthBox.Text = OPlannerHelper.PixelsToMillimetres(OPlannerDefaults.LineWidth).ToString();
		}

		private void resetNumberSizeButton_Click(object sender, RoutedEventArgs e) {
			numberSizeBox.Text = OPlannerHelper.PixelsToMillimetres(OPlannerDefaults.NumberSize).ToString();
		}

		private void resetNumberOffsetButton_Click(object sender, RoutedEventArgs e) {
			numberOffsetBox.Text = OPlannerHelper.PixelsToMillimetres(OPlannerDefaults.NumberOffsetDistance).ToString();
		}

		private void resetControlColourButton_Click(object sender, RoutedEventArgs e) {
			controlColourBox.Text = OPlannerDefaults.ControlColour;
		}

		private void resetDescriptionSizeButton_Click(object sender, RoutedEventArgs e) {
			descriptionSizeBox.Text = OPlannerHelper.PixelsToMillimetres(OPlannerDefaults.DescriptionSize).ToString();
		}

	}

}
