﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace OPlanner {
	
	public partial class CourseProperties : Window {

		public CourseProperties() {
			InitializeComponent();
		}

		private Course course;
		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
		}

		public void SetCourse(Course newCourse) {
			course = newCourse;
			UpdateCourseInfo();
		}

		public Course GetCourse() {
			return course;
		}

		private void UpdateCourseInfo() {
			Clear();
			if (course == null) {
				return;
			}
			courseNameBox.Text = course.Name;
			if (course.Climb != 0) {
				climbBox.Text = course.Climb.ToString();
			} else {
				climbBox.Text = "";
			}
			if (course.ExtraLength != 0) {
				extraLengthBox.Text = course.ExtraLength.ToString();
			} else {
				extraLengthBox.Text = "";
			}
			tapesToFinishBox.IsChecked = course.TapesToFinish;
		}

		private void Clear() {
			courseNameBox.Text = "";
			climbBox.Text = "";
			extraLengthBox.Text = "";
			tapesToFinishBox.IsChecked = false;
		}

		private bool Validate(bool showErrors) {
			ErrorManager errorManager = new ErrorManager();
			double num;
			bool isNew = false;
			if (course == null) {
				isNew = true;
			}
			bool changeName = false;
			if (isNew) {
				changeName = true;
			}
			string name = courseNameBox.Text;
			if (name == "") {
				errorManager.AddError("Name is required");
			} else {
				if (course != null) {
					if (course.Name != name) {
						changeName = true;
					}
				}
				if (changeName) {
					if (info.Data.CourseExists(name)) {
						errorManager.AddError("Course name already exits");
					}
				}
			}
			if (climbBox.Text != "") {
				if (!double.TryParse(climbBox.Text, out num)) {
					errorManager.AddError("Climb must be a number");
				} else {
					if (num < 0) {
						errorManager.AddError("Climb must be a positive number");
					}
				}
			}
			if (extraLengthBox.Text != "") {
				if (!double.TryParse(extraLengthBox.Text, out num)) {
					errorManager.AddError("Extra length must be a number");
				}
			}
			if (showErrors) {
				errorManager.ShowErrors(this);
			}
			return !errorManager.HasErrors;
		}

		private void saveButton_Click(object sender, RoutedEventArgs e) {
			if (!Validate(true)) {
				return;
			}
			bool isNew = false;
			if (course == null) {
				isNew = true;
			}
			string name = courseNameBox.Text;
			double climb = 0;
			if (climbBox.Text != "") {
				climb = double.Parse(climbBox.Text);
			}
			double extraLength = 0;
			if (extraLengthBox.Text != "") {
				extraLength = double.Parse(extraLengthBox.Text);
			}
			if (isNew) {
				course = new Course(info.Data);
				info.InvokeDataChanging(this, "Create Course");
			}
			bool tapesToFinish = false;
			if (tapesToFinishBox.IsChecked == true) {
				tapesToFinish = true;
			}
			if (course.Name != name || course.Climb != climb || course.ExtraLength != extraLength || course.TapesToFinish != tapesToFinish) {
				if (!isNew) {
					info.InvokeDataChanging(this, "Modify Course");
				}
				course.Name = name;
				course.Climb = climb;
				course.ExtraLength = extraLength;
				course.TapesToFinish = tapesToFinish;
				if (!isNew) {
					info.InvokeDataChanged(this, "Modify Course");
					info.InvokeObjectsUpdated(this, UpdateType.Redraw, null, true);
				}
			}
			if (isNew) {
				info.Data.Courses.Add(course);
				info.InvokeDataChanged(this, "Create Course");
				info.InvokeCourseCreated(this);
			}
			Close();
		}

		private void cancelButton_Click(object sender, RoutedEventArgs e) {
			Close();
		}

	}

}
