﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace OPlanner {

	public class UndoRedoData {

		public OCurrentInfoBase BaseInfo;
		public string UndoRedoText;

		public UndoRedoData() {
		}

		public UndoRedoData(OCurrentInfoBase baseInfo, string undoRedoText) {
			BaseInfo = baseInfo;
			UndoRedoText = undoRedoText;
		}

	}

	public class UndoRedo {

		private List<UndoRedoData> undoList;
		private List<UndoRedoData> redoList;
		private static int maxUndo;

		static UndoRedo() {
			maxUndo = 20;
		}

		public UndoRedo() {
			undoList = new List<UndoRedoData>();
			redoList = new List<UndoRedoData>();
		}

		public void SaveData(OCurrentInfoBase baseInfo, string undoRedoText) {
			undoList.Add(new UndoRedoData(baseInfo.Clone(), undoRedoText));
			redoList.Clear();
			if (undoList.Count > maxUndo) {
				undoList.RemoveAt(0);
			}
		}

		public OCurrentInfoBase Undo(OCurrentInfoBase currentBaseInfo) {
			if (!CanUndo) {
				return currentBaseInfo;
			}
			OCurrentInfoBase temp = undoList[undoList.Count - 1].BaseInfo.Clone();
			redoList.Add(new UndoRedoData(currentBaseInfo.Clone(), undoList[undoList.Count - 1].UndoRedoText));
			undoList.RemoveAt(undoList.Count - 1);
			return temp;
		}

		public OCurrentInfoBase Redo(OCurrentInfoBase currentBaseInfo) {
			if (!CanRedo) {
				return currentBaseInfo;
			}
			OCurrentInfoBase temp = redoList[redoList.Count - 1].BaseInfo.Clone();
			undoList.Add(new UndoRedoData(currentBaseInfo.Clone(), redoList[redoList.Count - 1].UndoRedoText));
			redoList.RemoveAt(redoList.Count - 1);
			return temp;
		}

		public void Clear() {
			undoList.Clear();
			redoList.Clear();
		}

		public bool CanUndo {
			get {
				if (undoList.Count == 0) {
					return false;
				}
				return true;
			}
		}

		public bool CanRedo {
			get {
				if (redoList.Count == 0) {
					return false;
				}
				return true;
			}
		}

		public string UndoText {
			get {
				if (undoList.Count == 0) {
					return "";
				}
				return undoList[undoList.Count-1].UndoRedoText;
			}
		}

		public string RedoText {
			get {
				if (redoList.Count == 0) {
					return "";
				}
				return redoList[redoList.Count - 1].UndoRedoText;
			}
		}

	}

}
