﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace OPlanner {

	public partial class ToolsPanel : UserControl {

		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
			info.DataLoaded += new BasicEventHandler(DataLoadedHandler);
			info.ObjectsSelected += new SenderEventHandler(ObjectsSelectedHandler);
			info.ObjectsDeselected += new SenderEventHandler(ObjectsSelectedHandler);
			info.CourseSelected += new SenderEventHandler(CourseSelectedHandler);
		}

		void CourseSelectedHandler(object sender) {
			UpdateToolButtons();
		}

		void ObjectsSelectedHandler(object sender) {
			UpdateRotateButton();
			UpdatePointsButtons();
		}

		private List<OToolButton> radioButtons;
		private List<OToolButton> drawingModeButtons;

		public ToolsPanel() {
			radioButtons = new List<OToolButton>();
			drawingModeButtons = new List<OToolButton>();
			InitializeComponent();
		}

		private void DataLoadedHandler() {
			UpdateToolButtons();
			UpdateDrawingModeButtons();
		}

		private void UpdateRotateButton() {
			rotateButton.IsEnabled = false;
			if (info.SelectedObjects.Count != 1) {
				return;
			}
			if (info.SelectedObjects[0].GetObject(typeof(IRotatableObject)) == null) {
				return;
			}
			rotateButton.IsEnabled = true;
		}

		private void UpdatePointsButtons() {
			removePointButton.IsEnabled = false;
			addNormalPointButton.IsEnabled = false;
			addCurvePointButton.IsEnabled = false;
			if (info.SelectedObjects.Count != 1) {
				return;
			}
			if (info.SelectedObjects[0].GetObject(typeof(ODrawingObject)) == null) {
				return;
			}
			removePointButton.IsEnabled = true;
			addNormalPointButton.IsEnabled = true;
			addCurvePointButton.IsEnabled = true;
		}

		private void UpdateToolButtons() {
			for (int i = 0; i < radioButtons.Count; i++) {
				if (radioButtons[i].ToolType == info.SelectedTool && radioButtons[i].CreateMode == info.CreateMode) {
					radioButtons[i].Checked -= new RoutedEventHandler(radioButton_Checked);
					radioButtons[i].IsChecked = true;
					radioButtons[i].Checked += new RoutedEventHandler(radioButton_Checked);
				}
			}
			for (int i = 0; i < radioButtons.Count; i++) {
				if (radioButtons[i].CreateMode == CreateMode.Course && info.SelectedCourse == null) {
					radioButtons[i].IsEnabled = false;
					if (radioButtons[i].IsChecked == true) {
						selectButton.IsChecked = true;
					}
				} else {
					radioButtons[i].IsEnabled = true;
				}
			}
			UpdateRotateButton();
			UpdatePointsButtons();
		}

		private void UpdateDrawingModeButtons() {
			for (int i = 0; i < drawingModeButtons.Count; i++) {
				if (drawingModeButtons[i].DrawingMode == info.DrawingMode) {
					drawingModeButtons[i].Checked -= new RoutedEventHandler(drawingModeButton_Checked);
					drawingModeButtons[i].IsChecked = true;
					drawingModeButtons[i].Checked += new RoutedEventHandler(drawingModeButton_Checked);
				} else {
					drawingModeButtons[i].IsChecked = false;
				}
				if (info.DrawingMode == DrawingMode.None) {
					drawingModeButtons[i].IsEnabled = false;
				} else {
					drawingModeButtons[i].IsEnabled = true;
				}
			}
		}

		private void radioButton_Checked(object sender, RoutedEventArgs e) {
			if (info == null) {
				return;
			}
			OToolButton rb = (OToolButton)sender;
			info.SelectedTool = rb.ToolType;
			info.CreateMode = rb.CreateMode;
			if (rb.DrawingMode == DrawingMode.None) {
				info.DrawingMode = DrawingMode.None;
			} else {
				if (info.DrawingMode == DrawingMode.None) {
					info.DrawingMode = rb.DrawingMode;
				}
			}
			UpdateDrawingModeButtons();
			info.InvokeToolSelected(this);
		}

		private void radioButton_Loaded(object sender, RoutedEventArgs e) {
			OToolButton rb = (OToolButton)sender;
			if (!radioButtons.Contains(rb)) {
				radioButtons.Add(rb);
			}
		}

		private void drawingModeButton_Checked(object sender, RoutedEventArgs e) {
			if (info == null) {
				return;
			}
			OToolButton rb = (OToolButton)sender;
			info.DrawingMode = rb.DrawingMode;
			info.InvokeToolSelected(this);
		}

		private void drawingModeButton_Loaded(object sender, RoutedEventArgs e) {
			OToolButton rb = (OToolButton)sender;
			if (!drawingModeButtons.Contains(rb)) {
				drawingModeButtons.Add(rb);
			}
		}

	}

}
