﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Xps;
using System.Windows.Xps.Packaging;
using Microsoft.Win32;
using System.IO;
using System.IO.Packaging;
using System.Printing;
using System.Windows.Markup;
using System.Threading;
using System.Xml;

namespace OPlanner {

	public partial class PrintPreview : Window {

		private PrintDialog printDialog;
		private FixedDocument fixedDoc;
		private string printName;

		public PrintPreview() {
			InitializeComponent();
			printName = "OPlanner Document";
		}

		public void SetPrintDialog(PrintDialog dialog) {
			printDialog = dialog;
		}

		public void SetFixedDoc(FixedDocument newFixedDoc) {
			fixedDoc = newFixedDoc;
			mainViewer.Document = fixedDoc;
		}

		public void SetPrintName(string newPrintName) {
			printName = newPrintName;
		}

		protected void OnPrint(object sender, EventArgs e) {
			PrintQueue queue = printDialog.PrintQueue;
			queue.CurrentJobSettings.Description = printName;
			XpsDocumentWriter writer = PrintQueue.CreateXpsDocumentWriter(queue);
			writer.WriteAsync(fixedDoc, printDialog.PrintTicket);
		}
	
	}

}
